﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading.Tasks;

namespace MVVM
{
    public class ApplicationViewModel : INotifyPropertyChanged
    {
        private Trader selectedTrader;

        public ObservableCollection<Trader> Traders { get; set; }

        // команда добавления нового объекта
        private RelayCommand addCommand;
        public RelayCommand AddCommand
        {
            get
            {
                return addCommand ??
                  (addCommand = new RelayCommand(obj =>
                  {
                      Trader trader = new Trader();
                      Traders.Insert(0, trader);
                      SelectedTrader = trader;
                  }));
            }
        }


        public Trader SelectedTrader
        {
            get { return selectedTrader; }
            set
            {
                selectedTrader = value;
                OnPropertyChanged("SelectedTrader");
            }
        }

        public ApplicationViewModel()
        {
            Traders = new ObservableCollection<Trader>
            {
                new Trader { Name="Name 1", Surname="Surname 1", Account=12345 },
                new Trader { Name="Name 2", Surname="Surname 2", Account=67890 },
                new Trader { Name="Name 3", Surname="Surname 3", Account=44444 },
                new Trader { Name="Name 4", Surname="Surname 4", Account=99999 }
            };
        }

        public event PropertyChangedEventHandler PropertyChanged;
        public void OnPropertyChanged([CallerMemberName]string prop = "")
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(prop));
        }
    }
}
