﻿namespace CandleConverter
{

    using StockSharp.Algo;
    using StockSharp.Algo.History.Russian.Finam;
    using StockSharp.Algo.Storages;
    using StockSharp.BusinessEntities;
    using StockSharp.Messages;
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Globalization;
    using System.IO;
    using System.Linq;


    class Program
    {

        static void Main(string[] args)
        {

            // Create Security 
            var security = new Security() { Id = "ACCN@NYSE", Board = ExchangeBoard.Nyse };

            string rawDataPath = @"../../ACCN.txt";

            if (!File.Exists(rawDataPath))
            {
                Console.WriteLine("File {0} not found", rawDataPath);
                Console.Read();
                int code =0;
                Environment.Exit(code);
            }

            // Read the raw data from the file
            var lines = File.ReadAllLines(rawDataPath);

            // Candle time frame
            var timeFrame = TimeSpan.FromMinutes(5);

            var candleMessages = new List<CandleMessage>();

            // raw data parsing
            for (var i = 0; i < lines.Count(); i++)
            {
                var arr = lines[i].Split(',');

                var openTime = DateTimeOffset.ParseExact(arr[0] + arr[1], "dd/MM/yyyyHHmm", null);

                var message = new TimeFrameCandleMessage
                {
                    SecurityId = security.ToSecurityId(),
                    Arg = timeFrame,
                    OpenTime = openTime,
                    OpenPrice = decimal.Parse(arr[2], CultureInfo.InvariantCulture),
                    HighPrice = decimal.Parse(arr[3], CultureInfo.InvariantCulture),
                    LowPrice = decimal.Parse(arr[4], CultureInfo.InvariantCulture),
                    ClosePrice = decimal.Parse(arr[5], CultureInfo.InvariantCulture),
                    CloseTime = openTime.Add(timeFrame),
                    TotalVolume = decimal.Parse(arr[6], CultureInfo.InvariantCulture)
                };

                candleMessages.Add(message);
            }


            // Path to the root folder of the storage
            string path = @"../Data";

            if (!Directory.Exists(path))
                Directory.CreateDirectory(path);

            // Create StorageRegistry
            StorageRegistry storage = new StorageRegistry()
            {
                DefaultDrive = new LocalMarketDataDrive() { Path = path }
            };

            // get the CandleMessageStorage
            IMarketDataStorage<CandleMessage> candleStorage = storage.GetCandleMessageStorage(typeof(TimeFrameCandleMessage), security, timeFrame);

            // Save messages list to the storage
            candleStorage.Save(candleMessages);

            Console.Read();

        }

    }
}
