namespace SampleSMA
{
	using StockSharp.Algo;
	using StockSharp.Algo.Candles;
	using StockSharp.Algo.Indicators;
	using StockSharp.Algo.Indicators.Trend;
	using StockSharp.Algo.Strategies;
	using StockSharp.BusinessEntities;

    using System;

	class SmaStrategy : Strategy
	{
		private readonly CandleSeries _series;
		private bool _isShortLessThenLong;

		public SmaStrategy(CandleSeries series, SimpleMovingAverage longSma, SimpleMovingAverage shortSma)
		{
			_series = series;

			LongSma = longSma;
			ShortSma = shortSma;
		}

		public SimpleMovingAverage LongSma { get; private set; }
		public SimpleMovingAverage ShortSma { get; private set; }

		protected override void OnStarting()
		{
			_series
				.WhenCandlesFinished()
				.Do(ProcessCandle)
				.Apply(this);

			//      
			_isShortLessThenLong = ShortSma.LastValue < LongSma.LastValue;
            
			base.OnStarting();
		}
//
        public String _candle { get; private set; }

		private void ProcessCandle(Candle candle)
		{
			//      
			if (ProcessState == ProcessStates.Stopping)
			{
				//   
				CancelActiveOrders();
				return;
			}

			//   
			LongSma.Process((DecimalIndicatorValue)candle.ClosePrice);
			ShortSma.Process((DecimalIndicatorValue)candle.ClosePrice);
//
            _candle = candle.OpenTime.ToLongTimeString();

			//      
			var isShortLessThenLong = ShortSma.LastValue < LongSma.LastValue;

			//   
			if (_isShortLessThenLong != isShortLessThenLong)
			{
				//     ,  , , .
				var direction = isShortLessThenLong ? OrderDirections.Sell : OrderDirections.Buy;

				//   (  -  )
				//RegisterOrder(this.CreateOrder(direction, (decimal)Security.GetCurrentPrice(direction), Volume));

				//    
				var strategy = new MarketQuotingStrategy(direction, Volume);
				ChildStrategies.Add(strategy);

				//      
				_isShortLessThenLong = isShortLessThenLong;
			}
		}
	}
}