﻿// AN Код стратегии взят из примера SampleHistoryTestingParallel
// AN Всё что изменено помечено комментарием с префиксом AN

namespace SmaStrategy
{
	using System;

	using StockSharp.Algo;
	using StockSharp.Algo.Candles;
	using StockSharp.Algo.Indicators.Trend;
	using StockSharp.Algo.Strategies;
	using StockSharp.BusinessEntities;

	public class SmaStrategy : TimeFrameStrategy
		, Optimization.IStrategy4Optimization // AN Добавлено - требуется для оптимизации
	{

		// AN Удалил readonly, т.к. инициируется не в конструкторе было: private readonly CandleManager _candleManager;
		private CandleManager _candleManager;

		private bool _isShortLessThenLong;

		private DateTime _nextTime;

		#region AN Зона изменений для целей оптимизации

		// AN Добавлено для метода Parametrs{get}
		public Optimization.Parameters parametrs = new Optimization.Parameters();
		// AN Добавлено, т.к. требует интерфейс IStrategy4Optimization
		public Optimization.Parameters Parametrs { get { return parametrs; } }

		/* AN данный конструктор был удален, т.к. оптимизация требует конструктора без параметров
		 * Вместо этого, всё что требуется для стратегии создается в методе OnStarting
		public SmaStrategy(CandleManager candleManager, SimpleMovingAverage longSma, SimpleMovingAverage shortSma, TimeSpan timeFrame)
			: base(timeFrame)
		{
			_candleManager = candleManager;

			this.LongSma = longSma;
			this.ShortSma = shortSma;
		} */

		// AN Оптимизация требует конструктора без параметров, вместо этого параметры конфигурируются в конструкторе
		public SmaStrategy()
			: base(TimeSpan.FromSeconds(5*60)) // При использовании TimeSpan.MinValue валится с ошибкой, на что то это место влияет :(
		{
			Parametrs.Add("TimeFrame(sec)", 5 * 60, 5 * 60, 0, 5 * 60);
			Parametrs.Add("LongSma",  50, 100, 1, 60);
			Parametrs.Add("ShortSma", 4,  49,  1,  6 );
		}

		#endregion AN Конец зоны изменений для целей оптимизации

		public SimpleMovingAverage LongSma { get; private set; }
		public SimpleMovingAverage ShortSma { get; private set; }

		protected override void OnStarting()
		{
			#region AN Добавления для оптимизации (это было перенесено из конструктора)

			base.TimeFrame = TimeSpan.FromSeconds((int)Parametrs["TimeFrame(sec)"].Value);

			_candleManager = new CandleManager(new SyncTraderCandleSource(Trader)); // TODO Надо както менять SyncTraderCandleSource при реальной торговле, хотя любые изменния в коде при переносе в бой - зло
			((CandleContainer)_candleManager.Container).MaxCandleCount = 100;
			((CandleContainer)_candleManager.Container).MaxTradeCount = 100000;
			_candleManager.RegisterTimeFrameCandles(Security, TimeFrame);

			LongSma = new SimpleMovingAverage((int)Parametrs["LongSma"].Value);
			ShortSma = new SimpleMovingAverage((int)Parametrs["ShortSma"].Value);

			#endregion AN Добавления для оптимизации (это было перенесено из конструктора)

			// запоминаем текущее положение относительно друг друга
			_isShortLessThenLong = this.ShortSma.Value < this.LongSma.Value;

			// вычисляем время окончания текущей пятиминутки
			_nextTime = base.TimeFrame.GetCandleBounds(base.Trader).Max;

			base.OnStarting();
		}

		protected override ProcessResults OnProcess()
		{
			// если наша стратегия в процессе остановки
			if (base.ProcessState == ProcessStates.Stopping)
			{
				// отменяем активные заявки
				base.CancelActiveOrders();

				// так как все активные заявки гарантированно были отменены, то возвращаем StrategyProcessResults.Stop
				return ProcessResults.Stop;
			}

			// событие обработки торговой стратегии вызвалось впервый раз, что раньше, чем окончания текущей 5-минутки.
			if (base.Trader.MarketTime < _nextTime)
			{
				// возвращаем StrategyProcessResults.Continue, так как наш алгоритм еще не закончил свою работу, а просто ожидает следующего вызова.
				return ProcessResults.Continue;
			}

			// получаем сформированную свечку
			var candle = _candleManager.GetTimeFrameCandle(base.Security, base.TimeFrame, _nextTime - base.TimeFrame);

			// если свечки не существует (не было ни одной сделке в тайм-фрейме), то ждем окончания следующей свечки.
			if (candle == null)
			{
				// если прошло больше 10 секунд с момента окончания свечки, а она так и не появилась,
				// значит сделок в прошедшей 5-минутке не было, и переходим на следующую свечку
				if ((base.Trader.MarketTime - _nextTime) > TimeSpan.FromSeconds(10))
					_nextTime = base.TimeFrame.GetCandleBounds(base.Trader.MarketTime).Max;

				return ProcessResults.Continue;
			}

			_nextTime += base.TimeFrame;

			// добавляем новую свечку
			this.LongSma.Add(candle.ClosePrice);
			this.ShortSma.Add(candle.ClosePrice);

			// вычисляем новое положение относительно друг друга
			var isShortLessThenLong = this.ShortSma.Value < this.LongSma.Value;

			// если произошло пересечение
			if (_isShortLessThenLong != isShortLessThenLong)
			{
				// если короткая меньше чем длинная, то продажа, иначе, покупка.
				var direction = isShortLessThenLong ? OrderDirections.Sell : OrderDirections.Buy;

				// создаем заявку
				var order = this.CreateOrder(direction, base.Security.GetMarketPrice(direction), base.Volume);

				// регистрируем заявку (обычным способом - лимитированной заявкой)
				// base.RegisterOrder(order);

				// регистрируем заявку (через котирование)
				var strategy = new MarketQuotingStrategy(order, new Unit(), new Unit());
				base.ChildStrategies.Add(strategy);

				// запоминаем текущее положение относительно друг друга
				_isShortLessThenLong = isShortLessThenLong;
			}

			return ProcessResults.Continue;
		}
	}
}