﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Windows;
using System.Windows.Media;

using Ecng.Xaml;
using Ecng.Collections;

using StockSharp.Algo.Candles;
using StockSharp.Algo.Equity;
using StockSharp.Algo.Logging;
using StockSharp.Algo.Reporting;
using StockSharp.Algo.Testing;
using StockSharp.BusinessEntities;

using StockSharp.Algo.Storages;
//using StockSharp.BusinessEntities;
//using StockSharp.Algo.Testing;

namespace Optimizator
{
	/// <summary>
	/// Interaction logic for MainWindow.xaml
	/// </summary>
	public partial class MainWindow : Window
	{
		public MainWindow()
		{
			InitializeComponent();
		}
	
		bool runFlag;
		Optimization.BruteAlgorithm Optimizer;

		// выставляется из интерфейса
		TradingStorage storage;
		DateTime startTime;
		DateTime stopTime;
		TimeSpan timeFrame;		

		private void startNewStrategy()
		{
			// создаем тестовый инструмент, на котором будет производится тестирование
			var security = new Security
			{
				Id = "RIU9@RTS",
				Code = "RIU9",
				Name = "RTS-9.09",
				MinStepSize = 5,
				MinStepPrice = 2,
				Decimals = 0,
				Exchange = Exchange.Test,
			};

			// тестовый портфель
			var portfolio = new Portfolio { Name = "test account" };

			// создаем шлюз для эмуляции
			// инициализируем настройки (инструмент в истории обновляется раз в секунду)
			EmulationTrader trader = new EmulationTrader(
				new[] { security },
				new[] { portfolio },
				storage)
			{
				MarketTimeChangedInterval = timeFrame,
				Storage = storage,
				WorkingTime = Exchange.Rts.WorkingTime,
				// параметр влияет на занимаемую память.
				// в случае достаточно количества памяти на компьютере рекомендуется его увеличить
				DaysInMemory = 6,// TODO Стоит вынести в настройки?
			};			

			// * В стратегии стакан не используется? Сильно влияет на скорость?
			// * TODO Создание стакана вынести в виде флага на интерфейс
			trader.DepthGenerators[security] = new TrendMarketDepthGenerator(security)
			{
				// стакан для инструмента в истории обновляется раз в секунду
				Interval = TimeSpan.FromSeconds(1),
			};
			/*
			 * Требуемые менеджеры свечей создаются в стретегии.
			 * Требуется ли заморачиваться с синглтонами, фабриками?
			var candleManager = new CandleManager(new SyncTraderCandleSource(trader));
			 */

			// создаем торговую стратегию
			StockSharp.Algo.Strategies.Strategy	strategy = new SmaStrategy.SmaStrategy();
			strategy.Volume = 1;
			strategy.Security = security;
			strategy.Portfolio = portfolio;
			strategy.Trader = trader;

			// Устанавливаем параметры
			if (Optimizer.SetNextTestParametrs(strategy as Optimization.IStrategy4Optimization)
												   == StockSharp.Algo.Strategies.ProcessResults.Stop)
			{
				runFlag = false;
				return;
			}

			//strategy.EquityManager.NewEquityData += data => this.GuiAsync(() => curveItems.Add(data));

			// Двигаем полосу прогресса
			// this.GuiAsync(() => this.TestingProcess.Value = (trader.MarketTime - startTime).Ticks);

			// На самом деле return не должен срабатывать никогда
			// просто надо вызвать strategy.EquityManager.Parameters в связи с http://stocksharp.com/forum/yaf_postst1271_EquityManager.aspx
			if (strategy.EquityManager.Parameters == null)
				return;

			trader.ProcessDataError += new Action<Exception>(trader_ProcessDataError);

			trader.StateChanged += () =>
			{
				if (trader.State == EmulationStates.Stopped)
				{
					// Передаем полученный результат в алгоритм оптимизации
					Optimizer.StrategyResults.Add(strategy as Optimization.IStrategy4Optimization);

					//Запускаем следующую стратегию
					if (runFlag == true)
						startNewStrategy();
				}
				else if (trader.State == EmulationStates.Started)
				{
					// запускаем стратегию когда эмулятор запустился
					strategy.Start();
				}
			};
			// соединяемся с трейдером и запускаем экспорт,
			// чтобы инициализировать переданными инструментами и портфелями необходимые свойства EmulationTrader
			trader.Connect();
			trader.StartExport();
			// запускаем эмуляцию
			// указываем даты начала и конца тестирования
			trader.Start(startTime, stopTime);
		}

		void trader_ProcessDataError(Exception obj)
		{
			this.GuiAsync(() =>
			{
				MessageBox.Show("trader_ProcessDataError: " + obj.ToString());
			});
		}

		private void StartButton_Click(object sender, RoutedEventArgs e)
		{
			startButton.IsEnabled = false;
			stopButton.IsEnabled = true;

			runFlag = true;

			storage = new TradingStorage(new Ecng.Serialization.InMemoryStorage()) { BasePath = dataPath.Text };

			startTime = startTimeDatePicker.SelectedDate.Value;
			stopTime = stopTimeDatePicker.SelectedDate.Value;

			//threadCount.Text = 1;

			int threadCount = int.Parse(threadCountTextBox.Text);
			timeFrame = TimeSpan.FromSeconds(int.Parse(timeStepTextBox.Text));

			// Создаю алгоритм оптимизации
			Optimizer = new Optimization.BruteAlgorithm(
					new Optimization.StrategyResults(typeof(SmaStrategy.SmaStrategy), "RIU9@RTS", startTime, stopTime)
				);

			// Выводим результат в GUI
			strategyResultsControl1.SetSource(Optimizer.StrategyResults);

			strategyResultsControl1.MouseDoubleClick += new EventHandler<Optimization.StrategyResultEventArgs>(strategyResultsControl1_MouseDoubleClick);

			for (int i = 0; i < threadCount; ++i)
				startNewStrategy();
		}

		void strategyResultsControl1_MouseDoubleClick(object sender, Optimization.StrategyResultEventArgs e)
		{
			//  TimeSpan timeFrame, Optimization.Parameters Parametrs
			var newWindow = new RunStrategyWindow(startTime, stopTime, storage, timeFrame, Optimizer.StrategyResults.GetParameters(e.Result));
			newWindow.Show();
		}

		private void StopButton_Click(object sender, RoutedEventArgs e)
		{
			startButton.IsEnabled = true;
			stopButton.IsEnabled = false;

			runFlag = false;
		}
	}
}
