﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

using Microsoft.Windows.Controls;

namespace Optimization
{
	/// <summary>
	/// Interaction logic for StrategyResultsControl.xaml
	/// </summary>
	public partial class StrategyResultsControl : UserControl
	{
		public StrategyResultsControl()
		{
			InitializeComponent();
		}

		public void SetSource(StrategyResults StrategyResults)
		{
			StrategyResults.OnAdd += new EventHandler<StrategyResultEventArgs>(StrategyResults_OnAdd);
			foreach (decimal[] result in StrategyResults)
				StrategyResults_OnAdd(StrategyResults, new StrategyResultEventArgs(result));
		}

		object forLock = new object();
		Boolean needHeader = true;

		void StrategyResults_OnAdd(object sender, StrategyResultEventArgs e)
		{
			lock (forLock)
			{
				if (needHeader == true)
				{
					StrategyResults strategyResults = sender as StrategyResults;
					if (strategyResults == null)
						throw new FormatException("Ожидаю в качестве sender StrategyResults");

					for (int i = 0; i < strategyResults.Headers.Length; ++i)
					{
						dataGrid.Dispatcher.BeginInvoke(
							new Action<int>(idx =>
							{
								DataGridTextColumn column = new DataGridTextColumn();
								column.Header = strategyResults.Headers[idx];
								column.Binding = new Binding(String.Format("[{0}]", idx));
								dataGrid.Columns.Add(column);
							}),
							System.Windows.Threading.DispatcherPriority.Render,
							i);
					}
					needHeader = false;
				}
			}

			dataGrid.Dispatcher.BeginInvoke(
				new Action<decimal[]>(result => { dataGrid.Items.Add(result); }),
				System.Windows.Threading.DispatcherPriority.Render,
				e.Result);
		}

		public event EventHandler<StrategyResultEventArgs> MouseDoubleClick;


		private void dataGrid_MouseDoubleClick(object sender, MouseButtonEventArgs e)
		{
			// Получаю строку
			DependencyObject row = (DependencyObject)e.OriginalSource;
			// iteratively traverse the visual tree
			while ((row != null) &&
					!(row is DataGridRow))
			{
				row = VisualTreeHelper.GetParent(row);
			}
			if (row == null)
				return;

			if (((row as DataGridRow).Item is decimal[]) && (null != MouseDoubleClick))
				MouseDoubleClick(this, new StrategyResultEventArgs((row as DataGridRow).Item as decimal[]));
		}
	}
}