﻿using System;
using System.IO;
using System.Reflection;
using System.Collections.Generic;

using StockSharp.Algo.Equity;
using StockSharp.Algo.Strategies;
using StockSharp.BusinessEntities;

namespace Optimization
{
	public class StrategyResultEventArgs : EventArgs
	{
		public readonly decimal[] Result;

		public StrategyResultEventArgs(decimal[] Result)
		{
			this.Result = Result;
		}
	}

	[Serializable]
	public class StrategyResults : List<decimal[]>
	{
		public readonly Type TypeOfStrategy;
		public readonly string Security;
		public readonly DateTime From;
		public readonly DateTime Till;

		public string FileName
		{
			get
			{
				string result;
				// TODO Избавиться от константы
				result = Path.Combine(@"c:\test", TypeOfStrategy.FullName + " " +
												   Assembly.GetAssembly(TypeOfStrategy).GetName().Version.ToString());
				result = Path.Combine(result, Security);
				result = Path.Combine(result, From.ToString("yyyyMMdd") + "-" + Till.ToString("yyyyMMdd"));
				return result;
			}
		}

		public string[] Headers;
		public int ParamStartPos = -1;

		public StrategyResults(Type TypeOfStrategy, string SecurityID, DateTime From, DateTime Till)
		{
			this.TypeOfStrategy = TypeOfStrategy;
			this.Security = SecurityID;
			this.From = From;
			this.Till = Till;
		}

		public event EventHandler<StrategyResultEventArgs> OnAdd;

		public void Add(IStrategy4Optimization strategy)
		{
			if (strategy == null)
				throw new ArgumentNullException("strategy");

			if ((((Strategy)strategy).EquityManager == null) || (((Strategy)strategy).EquityManager.Parameters.Count == 0))
				throw new InvalidOperationException("((strategy.EquityManager != null) || (strategy.EquityManager.Parameters.Count == 0)), какой же результат у стратегии?");

			if ((strategy.Parametrs == null) || (strategy.Parametrs.Count == 0))
				throw new InvalidOperationException("((strategy.Parametrs != null) || (strategy.Parametrs.Count == 0)), что же оптимизировать?");

			// Формируем заголовок того, что будет храниться в 
			if (Headers == null)
			{
				ParamStartPos = ((Strategy)strategy).EquityManager.Parameters.Count + 1;
				Headers = new string[ParamStartPos + strategy.Parametrs.Count];

				int i = 0;

				Headers[i++] = "PnL";

				foreach (IEquityParameter p in ((Strategy)strategy).EquityManager.Parameters)
					Headers[i++] = p.Name;

				foreach (KeyValuePair<string, Parameter> kvp in strategy.Parametrs)
					Headers[i++] = kvp.Key;
			}

			// Сохраняем результататы тестирования и параметры
			decimal[] result = new decimal[Headers.Length];

			result[0] = ((Strategy)strategy).PnLManager.PnL;

			foreach (IEquityParameter p in ((Strategy)strategy).EquityManager.Parameters)
				result[Array.IndexOf(Headers, p.Name)] = p.Value;

			//((Strategy)strategy).EquityManager.Equity

			foreach (KeyValuePair<string, Parameter> kvp in strategy.Parametrs)
				result[Array.IndexOf(Headers, kvp.Key)] = kvp.Value.Value;

			base.Add(result);
			if (null != OnAdd)
				OnAdd(this, new StrategyResultEventArgs(result));
		}

		public Optimization.Parameters GetParameters(decimal[] r)
		{
			if (ParamStartPos==-1)
				throw new Exception("StrategyResults не инициирован");
			if (Headers.Length!= r.Length)
				throw new Exception("Некоректная длинна входного массива");

			var result = new Optimization.Parameters();

			for (int i = ParamStartPos; i < Headers.Length; ++i)
				result.Add(Headers[i], new Optimization.Parameter(r[i], r[i], 0, r[i]));

			return result;
		}
	}
}
