﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Optimization
{
	public class OnSetEventArgs : EventArgs
	{
		public readonly string Key;
		public readonly decimal Value;
		public OnSetEventArgs(string key, decimal value)
		{
			Key = key;
			Value = value;
		}
	}

	public class Parameters : Dictionary<string, Parameter>
	{
		public void Add(string key, decimal mininum, decimal maximum, decimal step, decimal value)
		{
			base.Add(key, new Parameter(mininum, maximum, step, value));
		}

		public event EventHandler<OnSetEventArgs> OnSet;

		public void Set(string key, decimal value)
		{
			EventHandler<OnSetEventArgs> temp = OnSet;
			if (temp != null)
				temp(this, new OnSetEventArgs(key, value));

			base[key].Value = value;
		}

		public void Set(Parameters newParameters)
		{
			Parameter tmp;

			foreach (KeyValuePair<string, Parameter> kvp in newParameters)
				if (this.TryGetValue(kvp.Key, out tmp))
					Set(kvp.Key, kvp.Value.Value);
				else
					Add(kvp.Key, kvp.Value.Mininum, kvp.Value.Maximum, kvp.Value.Step, kvp.Value.Value);
		}
	}

	public class Parameter
	{
		public readonly decimal Mininum;
		public readonly decimal Maximum;
		public readonly decimal Step;
		public decimal Value { get; internal set; }

		public Parameter(decimal Mininum, decimal Maximum, decimal Step, decimal Value)
		{
			this.Mininum = Mininum;
			this.Maximum = Maximum;
			this.Step    = Step;
			this.Value   = Value;
		}
	}
}