﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Optimization
{
	public class BruteAlgorithm
	{
		public readonly Optimization.StrategyResults StrategyResults;

		public BruteAlgorithm(Optimization.StrategyResults StrategyResults)
		{
			this.StrategyResults = StrategyResults;
		}

		Parameters strategyParameters = new Parameters();

		/// <summary>
		/// Установить в стратегию параметры оптимизации, для следущего расчета результатов
		/// </summary>
		/// <param name="strategy4Optimization">Стратегия, которой надо установить параметры</param>
		/// <returns>
		/// Возвращает StockSharp.Algo.Strategies.StrategyProcessResults
		///   Continue - можно запускать стратегию на рассчет
		///   Stop - Перебор параметров закончен. Запускать стратегию уже не надо.
		/// </returns>
		public StockSharp.Algo.Strategies.ProcessResults SetNextTestParametrs(Optimization.IStrategy4Optimization strategy4Optimization)
		{
			if (strategy4Optimization.Parametrs.Count == 0)
				return StockSharp.Algo.Strategies.ProcessResults.Stop;

			lock (strategyParameters)
			{
				// SetNextTestParametrs вызвался первый раз, инициирую strategyParameters
				if (strategyParameters.Count == 0)
				{
					// Копирую список параметров в оптимизатор
					strategyParameters = new Parameters();
					strategyParameters.Set(strategy4Optimization.Parametrs);
					// Устанавливаю минимальные значения в копии оптимизатора
					foreach (KeyValuePair<string, Parameter> kvp in strategyParameters)
						strategyParameters.Set(kvp.Key, kvp.Value.Mininum);
					// Копирую значения в стратегию
					strategy4Optimization.Parametrs.Set(strategyParameters);
					return StockSharp.Algo.Strategies.ProcessResults.Continue;
				}

				// Прохожусь по всем параметрам
				foreach (KeyValuePair<string, Parameter> kvp in strategyParameters)
				{
					if (kvp.Value.Value == kvp.Value.Maximum)
						strategyParameters.Set(kvp.Key, kvp.Value.Mininum);
					else
					{
						if ((kvp.Value.Value + kvp.Value.Step) >= kvp.Value.Maximum)
						{
							strategyParameters.Set(kvp.Key, kvp.Value.Maximum);
							strategy4Optimization.Parametrs.Set(strategyParameters);
							return StockSharp.Algo.Strategies.ProcessResults.Continue;
						}
						else
						{
							strategyParameters.Set(kvp.Key, kvp.Value.Value + kvp.Value.Step);
							strategy4Optimization.Parametrs.Set(strategyParameters);
							return StockSharp.Algo.Strategies.ProcessResults.Continue;
						}
					}
				}
				// Больше перебирать нечего, оптимизацию можно останавливать
				return StockSharp.Algo.Strategies.ProcessResults.Stop;
			}
		}
	}
}
